#!/bin/sh

echo "WARNING: The MGED Command Help file has been manually set from the"
echo "         export of the MGED Users Manual (external document) and is"
echo "         no longer in sync with the previous html command files"
echo "         stored here.  (This is a temporary solution until a better"
echo "         system is in place)"

#########################################################################
#									#
#			    build_def_index.sh				#
#									#
# Use this shell script to build an HTML index file from one or more	#
# definition files. In this context, a definition file is one that	#
# contains HTML definition terms of the following forms:		#
#									#
#    <DT><a NAME="term_anchor_name"><B>term_name</B></DT>		#
#				or					#
#    <DT><a NAME="term_anchor_name"><B>term_name</B> <I>args</I></DT>	#
#									#
# Author -								#
#	Robert G. Parker						#
#									#
#########################################################################

NUM_COLUMNS_INDEX=3
CELLSPACING_INDEX=8

NUM_COLUMNS=5
CELLSPACING=4

# Note that spaces are not allowed. Here we use comma's instead of spaces.
DEF_FILES_AND_TITLES="{{mged_cmds.html}{MGED,User,Commands}}
    {{mged_devel_cmds.html}{MGED,Developer,Commands}}"
TARGET_FILE=mged_cmd_index.html

if test -f $TARGET_FILE
then
    rm $TARGET_FILE
fi

echo "<!-- ******************** DO NOT EDIT ********************* -->" >> $TARGET_FILE
echo "<!-- This file was generated by running build_def_index.sh. -->" >> $TARGET_FILE
echo "" >> $TARGET_FILE
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">" >> $TARGET_FILE
echo "<HTML>" >> $TARGET_FILE
echo "" >> $TARGET_FILE
echo "<HEAD>" >> $TARGET_FILE
echo "<TITLE>MGED Command Index</Title>" >> $TARGET_FILE
echo "</HEAD>" >> $TARGET_FILE
echo "" >> $TARGET_FILE
echo "<BODY BGCOLOR=\"#E0D8c8\" TEXT=\"#000000\">" >> $TARGET_FILE
echo "" >> $TARGET_FILE

# Build index of definition indexes
DEF_INDEX_INDEX="<TABLE CELLSPACING=$CELLSPACING_INDEX>"
count=-1
for DEF_FILE_AND_TITLE in ${DEF_FILES_AND_TITLES}
do
	count=`expr $count + 1`
	if test `expr $count % $NUM_COLUMNS_INDEX` = 0
	then
		if test $count -gt 0
		then
			DEF_INDEX_INDEX="$DEF_INDEX_INDEX</TR>"
		fi

		DEF_INDEX_INDEX="$DEF_INDEX_INDEX<TR>"
	fi

	TITLE=`echo $DEF_FILE_AND_TITLE |
	    sed 's/{{[^{}][^{}]*}{\([^{}][^{}]*\)}}/\1/g
		s/,/ /g'`
	ANCHOR_NAME=`echo $DEF_FILE_AND_TITLE |
	    sed 's/{{[^{}][^{}]*}{\([^{}][^{}]*\)}}/\1/g
		s/,/_/g'`
	DEF_INDEX_INDEX="$DEF_INDEX_INDEX<TD><a href=\"$TARGET_FILE#$ANCHOR_NAME\">$TITLE</a></TD>"
done
DEF_INDEX_INDEX="$DEF_INDEX_INDEX</TR></TABLE>"

for DEF_FILE_AND_TITLE in ${DEF_FILES_AND_TITLES}
do
	DEF_FILE=`echo $DEF_FILE_AND_TITLE |
	    sed 's/{{\([^{}][^{}]*\)}{[^{}][^{}]*}}/\1/g'`
	TITLE=`echo $DEF_FILE_AND_TITLE |
	    sed 's/{{[^{}][^{}]*}{\([^{}][^{}]*\)}}/\1/g
		s/,/ /g'`
	ANCHOR_NAME=`echo $DEF_FILE_AND_TITLE |
	    sed 's/{{[^{}][^{}]*}{\([^{}][^{}]*\)}}/\1/g
		s/,/_/g'`

	DEFS_AND_ANCHORS=`sed -n 's/<DT>[ ]*<a[ ][ ]*NAME="\([a-zA-Z0-9_?%][a-zA-Z0-9_?%]*\)"[ ]*>[ ]*<B>[ ]*\([a-zA-Z0-9_?%][a-zA-Z0-9_?%]*\)[ ]*<\/B>.*/{{\2}{\1}}/p' $DEF_FILE`

	echo "<a NAME=\"$ANCHOR_NAME\">" >> $TARGET_FILE
	echo "$DEF_INDEX_INDEX" >> $TARGET_FILE
	echo "<CENTER><H1>$TITLE</H1></CENTER>" >> $TARGET_FILE
	echo "<TABLE CELLSPACING=$CELLSPACING>" >> $TARGET_FILE
	count=-1

	for DEF_AND_ANCHOR in ${DEFS_AND_ANCHORS}
	do
	    count=`expr $count + 1`
	    if test `expr $count % $NUM_COLUMNS` = 0
	    then
		if test $count -gt 0
		then
		    echo "</TR>" >> $TARGET_FILE
		fi

		echo "<TR>" >> $TARGET_FILE
	    fi

	    DEF=`echo $DEF_AND_ANCHOR |
		    sed 's/{{\([a-zA-Z0-9_?%][a-zA-Z0-9_?%]*\)}{[a-zA-Z0-9_?%][a-zA-Z0-9_?%]*}}/\1/g'`
	    ANCHOR=`echo $DEF_AND_ANCHOR |
		    sed 's/{{[a-zA-Z0-9_?%][a-zA-Z0-9_?%]*}{\([a-zA-Z0-9_?%][a-zA-Z0-9_?%]*\)}}/\1/g'`
	    echo "<TD><a href=\"$TARGET_FILE#$ANCHOR\">$DEF</a></TD>" >> $TARGET_FILE
	done

	echo "</TR>" >> $TARGET_FILE
	echo "</TABLE>" >> $TARGET_FILE
	echo "<HR>" >> $TARGET_FILE
	echo "" >> $TARGET_FILE
	cat $DEF_FILE >> $TARGET_FILE
done

echo "" >> $TARGET_FILE
echo "$DEF_INDEX_INDEX" >> $TARGET_FILE
echo "</BODY>" >> $TARGET_FILE
echo "</HTML>" >> $TARGET_FILE

# Local Variables:
# mode: sh
# tab-width: 8
# sh-indentation: 4
# sh-basic-offset: 4
# indent-tabs-mode: t
# End:
# ex: shiftwidth=4 tabstop=8
